/*
 * Decompiled with CFR 0.152.
 */
package com.bb.graph;

import com.bb.graph.clsAllForm;
import com.bb.graph.clsWindow;
import com.bb.graph.frmClusterHierarchysub;
import com.bb.graph.graphCluster;
import com.bb.graph.nodeCluster;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class frmClusterHierarchy
extends JPanel {
    private graphCluster grd;
    private HashMap<String, ArrayList<String>> nclAdlist;
    private int x;
    private int y;
    private String sk = "";
    private Color bcolor;

    public frmClusterHierarchy() {
        this.initComponents();
    }

    public frmClusterHierarchy(graphCluster gl) {
        this.initComponents();
        this.grd = gl;
        this.bcolor = clsWindow.fbackcolor;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackground(this.bcolor);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        float lineth = 0.0f;
        for (String key : this.grd.grpclus.keySet()) {
            nodeCluster ns = this.grd.grpclus.get(key);
            g2d.setColor(Color.BLUE);
            lineth = 0.1f;
            g2d.setStroke(new BasicStroke(lineth));
            g2d.fillOval(ns.xcor - ns.getCsize() / 2, ns.ycor - ns.getCsize() / 2, ns.getCsize(), ns.getCsize());
            g2d.drawOval(ns.xcor - ns.getCsize() / 2, ns.ycor - ns.getCsize() / 2, ns.getCsize(), ns.getCsize());
            g2d.setColor(Color.BLACK);
            g2d.setFont(clsWindow.vfont);
            g2d.drawString(ns.getCname(), ns.xcor + ns.getCsize() / 2 + 2, ns.ycor);
            for (Map.Entry<String, Integer> pair : ns.getAdclus().entrySet()) {
                nodeCluster nt = this.grd.grpclus.get(pair.getKey());
                lineth = (float)(Math.log(pair.getValue() + 1) / Math.log(2.0));
                if (!(lineth > 0.0f)) continue;
                g2d.setColor(clsWindow.edgcol);
                g2d.setStroke(new BasicStroke(lineth));
                g2d.drawLine(ns.xcor, ns.ycor, nt.xcor, nt.ycor);
            }
        }
        g2d.dispose();
        clsWindow.Hierarchyform = this;
    }

    private void initComponents() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                frmClusterHierarchy.this.formMouseDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                frmClusterHierarchy.this.formMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                frmClusterHierarchy.this.formMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMousePressed(MouseEvent evt) {
        this.x = evt.getX();
        this.y = evt.getY();
        this.sk = this.grd.selectnode(this.x, this.y);
    }

    private void formMouseDragged(MouseEvent evt) {
        int dx = evt.getX() - this.x;
        int dy = evt.getY() - this.y;
        this.grd.changenodecoorsel(this.sk, dx, dy);
        this.repaint();
        this.x += dx;
        this.y += dy;
    }

    private void formMouseClicked(MouseEvent evt) {
        clsWindow.Hierarchyform = this;
        if (evt.getClickCount() == 1) {
            return;
        }
        try {
            String slcl = this.grd.selectnode(this.x, this.y);
            nodeCluster slnd = this.grd.grpclus.get(slcl);
            ArrayList<String> ovnodeni = new ArrayList<String>();
            this.nclAdlist = new HashMap();
            for (int i = 0; i <= slnd.getMslist().size() - 1; ++i) {
                String node = slnd.getMslist().get(i);
                ArrayList<String> adcl = new ArrayList<String>();
                Vector nad = (Vector)this.grd.adlist.get(node);
                for (int j = 0; j <= nad.size() - 1; ++j) {
                    String cs = (String)nad.get(j);
                    for (String key : slnd.getAdclus().keySet()) {
                        if (this.grd.grpclus.get(key).getMslist().contains(cs) && !slnd.getMslist().contains(cs) && !adcl.contains(key)) {
                            adcl.add(key);
                        }
                        if (!this.grd.grpclus.get(key).getMslist().contains(node) || ovnodeni.contains(node)) continue;
                        ovnodeni.add(node);
                    }
                }
                if (adcl.size() <= 0) continue;
                this.nclAdlist.put(node, adcl);
            }
            if (ovnodeni.size() > 0) {
                slnd.setMsovlistnbr(ovnodeni);
            }
            JInternalFrame frame = new JInternalFrame("Single Hierarchical Node :" + slnd.getCname());
            frame.setClosable(true);
            frmClusterHierarchysub m1 = new frmClusterHierarchysub(slnd, this.grd.getAdlist(), this.nclAdlist);
            frame.setBounds(0, 0, 600, 600);
            clsAllForm.fmain.makeinternal(frame);
            frame.getContentPane().add(m1);
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Click Valid Region");
        }
    }
}

