/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DrawPanel
extends JPanel {
    Point start;
    double ovalSize;
    int[][] edgeCon = new int[MoveBall.ec][3];
    String[] colr = new String[MoveBall.ec];
    JComboBox oneClusterCb;
    String dir;
    Vector overlapClusV;
    OneClusterFrame ocf = null;

    public DrawPanel(String string, Vector vector) {
        Object object;
        this.setLayout(new BorderLayout());
        this.dir = string;
        this.overlapClusV = vector;
        JPanel jPanel = new JPanel(new BorderLayout());
        Vector<String> vector2 = new Vector<String>();
        vector2.add(" The independent nodes");
        for (int i = 0; i < MoveBall.vSingleNode.size(); ++i) {
            object = (node)MoveBall.vSingleNode.elementAt(i);
            vector2.add(((node)object).getName() + "  ------  " + ((node)object).getCircleSize());
        }
        this.oneClusterCb = new JComboBox(vector2);
        this.oneClusterCb.addActionListener(new oneClusterListener());
        jPanel.add((Component)this.oneClusterCb, "Center");
        JButton jButton = new JButton(" Display ");
        jButton.addActionListener(new oneClusterButtonListener());
        jPanel.add((Component)jButton, "East");
        this.add((Component)jPanel, "North");
        for (int i = 0; i <= MoveBall.ec - 1; ++i) {
            object = new StringTokenizer((String)MoveBall.edgeL.get(i));
            this.edgeCon[i][0] = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
            this.edgeCon[i][1] = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
            this.colr[i] = ((StringTokenizer)object).nextToken().trim();
            this.edgeCon[i][2] = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
        }
        canvasPanel canvasPanel2 = new canvasPanel(MoveBall.vertexList, MoveBall.edgeL, MoveBall.ec, MoveBall.d);
        this.add((Component)canvasPanel2, "Center");
    }

    void oneClusterWindow(String string) {
        String string2 = this.dir + MoveBall.filename;
        try {
            String[] stringArray;
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            bufferedReader.readLine();
            bufferedReader.readLine();
            int n = 0;
            while (!(string3 = bufferedReader.readLine()).equals("EDGES") && !string.equals((stringArray = string3.split("\t"))[0])) {
                ++n;
            }
            bufferedReader.close();
            this.viewOneCluster(n);
        }
        catch (IOException iOException) {
            System.out.println("error in IO");
        }
    }

    public synchronized void viewOneCluster(int n) throws IOException {
        try {
            String string;
            String string2 = this.dir + "/SeperateClusters_graph.txt";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            Vector<String> vector = new Vector<String>();
            String string3 = "clus" + String.valueOf(++n);
            boolean bl = false;
            while (!bl) {
                string = bufferedReader.readLine();
                if (!string.equals(string3)) continue;
                bl = true;
            }
            string3 = "clus" + String.valueOf(n + 1);
            bl = false;
            while (!bl) {
                string = bufferedReader.readLine();
                if (string.startsWith("clus")) {
                    bl = true;
                    continue;
                }
                vector.add(string);
            }
            bufferedReader.close();
            MoveBall_2.view_2(vector, n, this.dir);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    boolean isOneClusterFrameOpen() {
        return this.ocf != null;
    }

    void OneClusterFrameDispose() {
        this.ocf.dispose();
    }

    class OneClusterFrame
    extends JFrame {
        int hy = 0;

        public OneClusterFrame(Vector vector) {
            this.setLocation(ClusteringGUI.viewWinX + ClusteringGUI.viewWinW + 10, ClusteringGUI.viewWinY + 80);
            this.setSize(500, 400);
            this.setTitle("The independent nodes --- " + DrawPanel.this.dir);
            this.hy = ((node)vector.lastElement()).getPosition().y + 40;
            ViewPanel viewPanel = new ViewPanel(vector, this.hy);
            this.getContentPane().add(viewPanel);
            this.show();
        }

        class ViewPanel
        extends JPanel {
            public ViewPanel(Vector vector, int n) {
                this.setLayout(new BorderLayout());
                canvasPanel canvasPanel2 = new canvasPanel(vector, vector.size());
                canvasPanel2.setPreferredSize(new Dimension(400, n));
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.getViewport().add(canvasPanel2);
                this.add((Component)jScrollPane, "Center");
            }
        }
    }

    class canvasPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        Vector nodeList;
        Vector edg;
        int ecc;
        int tn;
        int mx = 0;
        int my = 0;
        int k = 0;
        int moveFlag = 0;

        public canvasPanel(Vector vector, int n) {
            this(vector, null, 0, n);
        }

        public canvasPanel(Vector vector, Vector vector2, int n, int n2) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.nodeList = vector;
            this.edg = vector2;
            this.ecc = n;
            this.tn = n2;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            node node2;
            this.mx = mouseEvent.getX();
            this.my = mouseEvent.getY();
            if (this.moveFlag == 1 && (node2 = (node)this.nodeList.get(this.k)) != null) {
                node2.setPosition(this.mx, this.my);
                this.nodeList.setElementAt(node2, this.k);
            }
            this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.mx = mouseEvent.getX();
            this.my = mouseEvent.getY();
            this.k = 0;
            for (int i = 0; i <= this.tn - 1; ++i) {
                node node2 = (node)this.nodeList.get(i);
                if (node2 == null) continue;
                DrawPanel.this.start = new Point(node2.position.x, node2.position.y);
                DrawPanel.this.ovalSize = node2.dia;
                if (!this.coordCheck(this.mx, this.my, DrawPanel.this.start, DrawPanel.this.ovalSize)) continue;
                this.moveFlag = 1;
                this.k = i;
                break;
            }
            if (this.moveFlag == 1) {
                try {
                    this.moveFlag = 0;
                    if (this.ecc == 0) {
                        DrawPanel.this.oneClusterWindow(((node)this.nodeList.get(this.k)).getName());
                    } else {
                        DrawPanel.this.viewOneCluster(this.k);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("error in IO");
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mx = mouseEvent.getX();
            this.my = mouseEvent.getY();
            this.k = 0;
            for (int i = 0; i <= this.tn - 1; ++i) {
                node node2 = (node)this.nodeList.get(i);
                if (node2 == null) continue;
                DrawPanel.this.start = new Point(node2.position.x, node2.position.y);
                DrawPanel.this.ovalSize = node2.dia;
                if (!this.coordCheck(this.mx, this.my, DrawPanel.this.start, DrawPanel.this.ovalSize)) continue;
                this.moveFlag = 1;
                this.k = i;
                break;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.moveFlag = 0;
        }

        public boolean coordCheck(int n, int n2, Point point, double d) {
            double d2 = d / 2.0;
            return point.getX() - d2 < (double)n && point.getX() + d2 > (double)n && point.getY() - d2 < (double)n2 && point.getY() + d2 > (double)n2;
        }

        public void paintComponent(Graphics graphics) {
            Object object;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(8.0f));
            int n = 0;
            try {
                for (n = 0; n <= this.ecc - 1; ++n) {
                    object = new edge((node)this.nodeList.get(DrawPanel.this.edgeCon[n][0]), (node)this.nodeList.get(DrawPanel.this.edgeCon[n][1]), DrawPanel.this.colr[n], DrawPanel.this.edgeCon[n][2]);
                    ((edge)object).draw(graphics2D);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("edge = " + n + "  " + arrayIndexOutOfBoundsException.getMessage());
            }
            graphics2D.setColor(Color.red);
            object = null;
            try {
                for (n = 0; n <= this.tn - 1; ++n) {
                    object = (node)this.nodeList.get(n);
                    if (object == null) continue;
                    ((node)object).draw(graphics2D, DrawPanel.this.overlapClusV);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("node = " + n + "  " + arrayIndexOutOfBoundsException.getMessage());
            }
        }

        public int[][] calPos(int n, int n2) {
            int[][] nArray = new int[n][n2];
            for (int i = 0; i < n; ++i) {
                nArray[i][0] = (int)Math.floor(Math.random() * 400.0);
                nArray[i][1] = (int)Math.floor(Math.random() * 300.0);
            }
            return nArray;
        }
    }

    class oneClusterButtonListener
    implements ActionListener {
        oneClusterButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!DrawPanel.this.isOneClusterFrameOpen()) {
                DrawPanel.this.ocf = new OneClusterFrame(MoveBall.vSingleNode);
            } else if (DrawPanel.this.ocf.isShowing()) {
                DrawPanel.this.ocf.toFront();
            } else {
                DrawPanel.this.ocf.show();
            }
        }
    }

    class oneClusterListener
    implements ActionListener {
        oneClusterListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = ((String)DrawPanel.this.oneClusterCb.getSelectedItem()).split("  ------  ");
            DrawPanel.this.oneClusterWindow(stringArray[0]);
        }
    }
}

