/*
 * Decompiled with CFR 0.152.
 */
package com.bb.graph;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import javax.swing.JOptionPane;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class clsMatrixData {
    private String[] rname;
    private String[] cname;
    private int[][] data;
    private int[][] rl;
    private float[][] tf;
    private int rsize;
    private int csize;
    private int thrl;
    private double thtf;
    private int rdirection;
    private String fpath = "";
    private String fsep = "";
    private ArrayList<String> bindata;

    public int getmatdata(String ft, String st) {
        int i = Arrays.asList(this.rname).indexOf(ft);
        int j = Arrays.asList(this.cname).indexOf(st);
        return this.data[i][j];
    }

    public ArrayList getclssecondtuple(ArrayList clsn, double pr) {
        ArrayList<String> st = new ArrayList<String>();
        for (int j = 0; j <= this.csize - 1; ++j) {
            double sum = 0.0;
            for (int i = 0; i <= clsn.size() - 1; ++i) {
                String sp = (String)clsn.get(i);
                int p = Arrays.asList(this.rname).indexOf(sp);
                if (this.data[p][j] != 1) continue;
                sum += 1.0;
            }
            double pp = sum / (double)clsn.size();
            if (!(pp >= pr)) continue;
            st.add(this.cname[j]);
        }
        return st;
    }

    public ArrayList removeisolatenode(ArrayList st, ArrayList ft) {
        ArrayList<String> nt = new ArrayList<String>();
        for (int i = 0; i <= st.size() - 1; ++i) {
            String sp1 = (String)st.get(i);
            int p = Arrays.asList(this.rname).indexOf(sp1);
            boolean flag = false;
            for (int j = 0; !flag && j < ft.size(); ++j) {
                String sp2 = (String)ft.get(j);
                int q = Arrays.asList(this.cname).indexOf(sp2);
                if (this.data[p][q] != 1) continue;
                flag = true;
            }
            if (!flag) continue;
            nt.add(sp1);
        }
        return nt;
    }

    public clsMatrixData(String fp, String sep, int rl, double tf) {
        this.fpath = fp;
        this.fsep = sep;
        this.thrl = rl;
        this.thtf = tf;
        this.rdirection = 0;
    }

    public clsMatrixData(String fp, String sep, int rl, double tf, int rd) {
        this.fpath = fp;
        this.fsep = sep;
        this.thrl = rl;
        this.thtf = tf;
        this.rdirection = rd;
    }

    public clsMatrixData(String fp, String sep) {
        this.fpath = fp;
        this.fsep = sep;
        this.thrl = 0;
        this.thtf = 0.0;
    }

    public ArrayList<String> getBindata() {
        return this.bindata;
    }

    public int getThrl() {
        return this.thrl;
    }

    public double getThtf() {
        return this.thtf;
    }

    public void processdata() {
        if (this.rdirection == 0) {
            this.datareadexcel();
        } else {
            this.datareadexcelrev();
        }
        this.relation();
        this.edgeset();
    }

    public void processdatatxt() {
        if (this.rdirection == 0) {
            this.datareadcsv(0);
        } else {
            this.datareadcsv(1);
        }
        this.relation();
        this.edgeset();
    }

    public void calculatethresold() {
        this.relation();
        this.findthresold();
        this.findthresoldrl();
    }

    public void findthresoldrl() {
        int i;
        ArrayList<String> edge = new ArrayList<String>();
        int k = 0;
        int maxrl = 0;
        int minrl = 999999999;
        for (int i2 = 0; i2 <= this.rsize - 1; ++i2) {
            for (int j = 0; j <= i2 - 1; ++j) {
                if (maxrl < this.rl[i2][j]) {
                    maxrl = this.rl[i2][j];
                }
                if (minrl <= this.rl[i2][j] || this.rl[i2][j] <= 0) continue;
                minrl = this.rl[i2][j];
            }
        }
        int[] edgenum = new int[maxrl - minrl + 1];
        for (int t = minrl; t <= maxrl; ++t) {
            edge = new ArrayList();
            for (i = 0; i <= this.rsize - 1; ++i) {
                for (int j = 0; j <= i - 1; ++j) {
                    if (this.rl[i][j] < t) continue;
                    if (!edge.contains(this.rname[i])) {
                        edge.add(this.rname[i]);
                    }
                    if (edge.contains(this.rname[j])) continue;
                    edge.add(this.rname[j]);
                }
            }
            edgenum[k] = edge.size();
            ++k;
        }
        int totedge = 0;
        for (i = k - 1; i >= 0; --i) {
            if (totedge >= edgenum[i]) continue;
            totedge = edgenum[i];
            this.thrl = maxrl - i;
        }
    }

    public void findthresold() {
        int i;
        ArrayList<String> edge = new ArrayList<String>();
        double[] thf = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        int[] edgenum = new int[10];
        for (int t = 0; t <= 9; ++t) {
            edge = new ArrayList();
            for (i = 0; i <= this.rsize - 1; ++i) {
                for (int j = 0; j <= i - 1; ++j) {
                    if (!((double)this.tf[i][j] >= thf[t])) continue;
                    if (!edge.contains(this.rname[i])) {
                        edge.add(this.rname[i]);
                    }
                    if (edge.contains(this.rname[j])) continue;
                    edge.add(this.rname[j]);
                }
            }
            edgenum[t] = edge.size();
        }
        int totedge = 0;
        for (i = 9; i >= 0; --i) {
            if (totedge >= edgenum[i]) continue;
            totedge = edgenum[i];
            this.thtf = thf[i];
        }
    }

    public void edgeset() {
        this.bindata = new ArrayList();
        for (int i = 0; i <= this.rsize - 1; ++i) {
            for (int j = 0; j <= i - 1; ++j) {
                if (this.rl[i][j] < this.thrl || !((double)this.tf[i][j] >= this.thtf)) continue;
                this.bindata.add(this.rname[i] + "\t" + this.rname[j]);
            }
        }
    }

    public void relation() {
        for (int i = 0; i <= this.rsize - 1; ++i) {
            for (int j = 0; j <= i - 1; ++j) {
                int rnum = 0;
                int cnum = 0;
                for (int k = 0; k <= this.csize - 1; ++k) {
                    if (this.data[i][k] == 1 && this.data[j][k] == 1) {
                        ++rnum;
                    }
                    if (this.data[i][k] + this.data[j][k] != 1) continue;
                    ++cnum;
                }
                this.rl[i][j] = rnum;
                this.tf[i][j] = (float)rnum / ((float)rnum + (float)cnum);
            }
        }
    }

    public void datareadexcel() {
        int i = 0;
        int j = 0;
        try {
            FileInputStream inputStream = new FileInputStream(new File(this.fpath));
            File f = new File(this.fpath);
            OPCPackage opcPackage = OPCPackage.open((String)f.getAbsolutePath());
            XSSFWorkbook workbook = new XSSFWorkbook(opcPackage);
            XSSFSheet firstSheet = workbook.getSheetAt(0);
            Iterator iterator = firstSheet.iterator();
            this.rsize = firstSheet.getLastRowNum();
            this.rname = new String[this.rsize];
            this.csize = firstSheet.getRow(0).getLastCellNum() - 1;
            this.cname = new String[this.csize];
            this.data = new int[this.rsize][this.csize];
            this.rl = new int[this.rsize][this.rsize];
            this.tf = new float[this.rsize][this.rsize];
            for (i = 1; i <= this.csize; ++i) {
                firstSheet.getRow(0).getCell(i).setCellType(1);
                this.cname[i - 1] = firstSheet.getRow(0).getCell(i).toString().trim();
            }
            for (i = 1; i <= this.rsize; ++i) {
                this.rname[i - 1] = firstSheet.getRow(i).getCell(0).toString().trim();
            }
            double d = 0.0;
            for (i = 1; i <= this.rsize; ++i) {
                for (j = 1; j <= this.csize; ++j) {
                    String ss = firstSheet.getRow(i).getCell(j).toString();
                    d = Double.parseDouble(ss);
                    this.data[i - 1][j - 1] = (int)d;
                }
            }
            i += 2;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString());
        }
    }

    public void datareadexcelrev() {
        int i = 0;
        int j = 0;
        try {
            FileInputStream inputStream = new FileInputStream(new File(this.fpath));
            File f = new File(this.fpath);
            OPCPackage opcPackage = OPCPackage.open((String)f.getAbsolutePath());
            XSSFWorkbook workbook = new XSSFWorkbook(opcPackage);
            XSSFSheet firstSheet = workbook.getSheetAt(0);
            Iterator iterator = firstSheet.iterator();
            this.rsize = firstSheet.getRow(0).getLastCellNum() - 1;
            this.rname = new String[this.rsize];
            this.csize = firstSheet.getLastRowNum();
            this.cname = new String[this.csize];
            this.data = new int[this.rsize][this.csize];
            this.rl = new int[this.rsize][this.rsize];
            this.tf = new float[this.rsize][this.rsize];
            for (i = 1; i <= this.rsize; ++i) {
                firstSheet.getRow(0).getCell(i).setCellType(1);
                this.rname[i - 1] = firstSheet.getRow(0).getCell(i).toString().trim();
            }
            for (i = 1; i <= this.csize; ++i) {
                this.cname[i - 1] = firstSheet.getRow(i).getCell(0).toString().trim();
            }
            double d = 0.0;
            for (i = 1; i <= this.rsize; ++i) {
                for (j = 1; j <= this.csize; ++j) {
                    String ss = firstSheet.getRow(j).getCell(i).toString();
                    d = Double.parseDouble(ss);
                    this.data[i - 1][j - 1] = (int)d;
                }
            }
            System.out.println("end");
            i += 2;
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void datareadcsv(int dir) {
        int i = 0;
        int j = 0;
        HashMap<String, Integer> sdata = new HashMap<String, Integer>();
        HashSet<String> fnode = new HashSet<String>();
        HashSet<String> snode = new HashSet<String>();
        try {
            Scanner scan = new Scanner(new FileInputStream(this.fpath));
            i = 1;
            while (scan.hasNextLine()) {
                String curLine = scan.nextLine();
                String[] splitted = curLine.split(this.fsep);
                if (dir == 0) {
                    fnode.add(splitted[0]);
                    snode.add(splitted[1]);
                    sdata.put(splitted[0] + "-" + splitted[1], j);
                } else {
                    fnode.add(splitted[1]);
                    snode.add(splitted[0]);
                    sdata.put(splitted[1] + "-" + splitted[0], j);
                }
                ++i;
            }
            ArrayList fnodea = new ArrayList(fnode);
            ArrayList snodea = new ArrayList(snode);
            this.rsize = fnodea.size();
            this.rname = new String[this.rsize];
            this.csize = snodea.size();
            this.cname = new String[this.csize];
            this.data = new int[this.rsize][this.csize];
            this.rl = new int[this.rsize][this.rsize];
            this.tf = new float[this.rsize][this.rsize];
            for (i = 0; i < fnodea.size(); ++i) {
                this.rname[i] = (String)fnodea.get(i);
            }
            for (i = 0; i < snodea.size(); ++i) {
                this.cname[i] = (String)snodea.get(i);
            }
            for (i = 0; i < fnodea.size(); ++i) {
                for (j = 0; j < snodea.size(); ++j) {
                    String key = (String)fnodea.get(i) + "-" + (String)snodea.get(j);
                    this.data[i][j] = sdata.containsKey(key) ? 1 : 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

