/*
 * Decompiled with CFR 0.152.
 */
package com.bb.graph;

import com.bb.graph.clsBinode;
import com.bb.graph.clsMatrixData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Vector;

public class clsBicluster
implements Serializable {
    private HashMap<Integer, clsBinode> bclus;
    ArrayList<String> cft = new ArrayList();
    ArrayList<String> cst = new ArrayList();

    public void setdatarandom() {
        int rand;
        int p = 0;
        Random randomGenerator = new Random();
        int i = this.cft.size();
        int j = this.cst.size();
        ArrayList<String> cftr = new ArrayList<String>();
        ArrayList<String> cstr = new ArrayList<String>();
        while (cftr.size() < i) {
            rand = randomGenerator.nextInt(i);
            if (!cftr.contains(rand)) {
                cftr.add(p, this.cft.get(rand));
            }
            ++p;
        }
        p = 0;
        while (cstr.size() < j) {
            rand = randomGenerator.nextInt(j);
            if (!cstr.contains(rand)) {
                cstr.add(p, this.cst.get(rand));
            }
            ++p;
        }
        this.cft.clear();
        this.cft.addAll(cftr);
        this.cst.clear();
        this.cst.addAll(cstr);
    }

    public void setdata() {
        int p = 0;
        int q = 0;
        for (Integer key : this.bclus.keySet()) {
            int i;
            clsBinode bn = this.bclus.get(key);
            ArrayList<String> ft = bn.getFtuple();
            for (i = 0; i <= ft.size() - 1; ++i) {
                if (this.cft.contains(ft.get(i))) continue;
                this.cft.add(p, ft.get(i));
                ++p;
            }
            ArrayList<String> st = bn.getStuple();
            for (i = 0; i <= st.size() - 1; ++i) {
                if (this.cst.contains(st.get(i))) continue;
                this.cst.add(q, st.get(i));
                ++q;
            }
        }
    }

    public HashMap<Integer, clsBinode> getBclus() {
        return this.bclus;
    }

    public clsBicluster() {
        this.bclus = new HashMap();
    }

    public void clsStcommon() {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.bclus.keySet());
        for (int i = 0; i <= keys.size() - 1; ++i) {
            ArrayList<String> std1 = new ArrayList<String>(this.bclus.get(keys.get(i)).getStuple());
            for (int j = 0; j <= i - 1; ++j) {
                ArrayList<String> std2 = new ArrayList<String>(this.bclus.get(keys.get(j)).getStuple());
                std1.retainAll(std2);
                int com = std1.size();
                std1 = new ArrayList<String>(this.bclus.get(keys.get(i)).getStuple());
                double per = (double)com / (double)(std1.size() + std2.size() - com) * 100.0;
                String string2 = Integer.toString(i + 1) + "," + Integer.toString(j + 1);
            }
        }
    }

    public clsBicluster(Vector msc, clsMatrixData md, double psc) {
        Vector ss = msc;
        this.bclus = new HashMap();
        for (int i = 0; i <= ss.size() - 1; ++i) {
            Vector cs = (Vector)ss.elementAt(i);
            ArrayList fs = new ArrayList(cs);
            ArrayList st = md.getclssecondtuple(fs, psc);
            ArrayList fsn = md.removeisolatenode(fs, st);
            ArrayList<String> stc = new ArrayList<String>(st);
            ArrayList<String> fsnc = new ArrayList<String>(fsn);
            clsBinode bn = new clsBinode(fsnc, stc);
            this.bclus.put(i + 1, bn);
        }
        this.bclus = this.sortByValue(this.bclus);
    }

    public clsBicluster(clsBicluster m1, clsBicluster m2) {
        clsBinode bn;
        this.bclus = new HashMap();
        HashMap<Integer, clsBinode> hs = m1.getBclus();
        int i = 0;
        for (Integer key : hs.keySet()) {
            bn = hs.get(key);
            if (bn.getFtuple().size() * bn.getStuple().size() <= 0) continue;
            this.bclus.put(i + 1, bn);
            ++i;
        }
        hs = m2.getBclus();
        for (Integer key : hs.keySet()) {
            bn = new clsBinode(hs.get(key).getStuple(), hs.get(key).getFtuple());
            if (bn.getFtuple().size() * bn.getStuple().size() <= 0) continue;
            this.bclus.put(i + 1, bn);
            ++i;
        }
        this.bclus = this.sortByValue(this.bclus);
        this.overlapping(1.0);
    }

    public void overlappinguser(double ov) {
        this.overlapping(ov);
        this.bclus = this.sortByValue(this.bclus);
    }

    private HashMap<Integer, clsBinode> sortByValue(HashMap<Integer, clsBinode> unsortMap) {
        LinkedList<Map.Entry<Integer, clsBinode>> list = new LinkedList<Map.Entry<Integer, clsBinode>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, clsBinode>>(){

            @Override
            public int compare(Map.Entry<Integer, clsBinode> o1, Map.Entry<Integer, clsBinode> o2) {
                Integer i = o1.getValue().getFtuple().size() * o1.getValue().getStuple().size();
                Integer j = o2.getValue().getFtuple().size() * o2.getValue().getStuple().size();
                return j.compareTo(i);
            }
        });
        LinkedHashMap<Integer, clsBinode> sortedMap = new LinkedHashMap<Integer, clsBinode>();
        int i = 1;
        for (Map.Entry entry : list) {
            sortedMap.put(i, (clsBinode)entry.getValue());
            ++i;
        }
        return sortedMap;
    }

    private void overlapping(double ovlpcf) {
        int i;
        int cl = this.bclus.size();
        double ol = 0.0;
        ArrayList<Object> xx2 = new ArrayList();
        ArrayList<Object> yy2 = new ArrayList();
        ArrayList<String> yy = new ArrayList<String>();
        ArrayList<Integer> ritem = new ArrayList<Integer>();
        double[][] ovlp = new double[cl][cl];
        int[] kset = new int[cl];
        int index = 0;
        for (Integer element : this.bclus.keySet()) {
            kset[index++] = element;
        }
        for (i = 2; i <= cl; ++i) {
            ArrayList<String> xx1 = this.bclus.get(kset[i - 1]).getFtuple();
            ArrayList<String> yy1 = this.bclus.get(kset[i - 1]).getStuple();
            for (int j = 1; j <= i - 1; ++j) {
                xx2 = this.bclus.get(kset[j - 1]).getFtuple();
                yy2 = this.bclus.get(kset[j - 1]).getStuple();
                double x1 = xx1.size();
                double x2 = xx2.size();
                double y1 = yy1.size();
                double y2 = yy2.size();
                ArrayList<String> xx = new ArrayList<String>();
                xx.addAll(xx1);
                xx.retainAll(xx2);
                yy = new ArrayList();
                yy.addAll(yy1);
                yy.retainAll(yy2);
                double xy1 = xx.size();
                double xy2 = yy.size();
                ovlp[i - 1][j - 1] = xy1 * xy2 / (x1 * y1 + x2 * y2 - xy1 * xy2);
            }
        }
        for (i = 2; i <= cl; ++i) {
            for (int j = 1; j <= i - 1; ++j) {
                if (!(ovlp[i - 1][j - 1] >= ovlpcf)) continue;
                ritem.add(kset[i - 1]);
            }
        }
        this.bclus.keySet().removeAll(ritem);
    }

    public void clusterjoin(double ovlpcf) {
        boolean ovchk = true;
        int mi = 0;
        int mj = 0;
        ArrayList<Object> xx2 = new ArrayList();
        ArrayList<Object> yy2 = new ArrayList();
        ArrayList<String> yy = new ArrayList<String>();
        HashSet<Object> nyy = new HashSet();
        while (ovchk) {
            ArrayList<Object> yy1;
            ArrayList<String> xx1;
            int cl = this.bclus.size();
            int[] kset = new int[cl];
            int index = 0;
            for (Integer element : this.bclus.keySet()) {
                kset[index++] = element;
            }
            double maxov = 0.0;
            for (int i = 1; i <= cl - 1; ++i) {
                xx1 = this.bclus.get(kset[i]).getFtuple();
                yy1 = this.bclus.get(kset[i]).getStuple();
                for (int j = 0; j <= i - 1; ++j) {
                    xx2 = this.bclus.get(kset[j]).getFtuple();
                    yy2 = this.bclus.get(kset[j]).getStuple();
                    double x1 = xx1.size();
                    double x2 = xx2.size();
                    double y1 = yy1.size();
                    double y2 = yy2.size();
                    ArrayList<String> xx = new ArrayList<String>();
                    xx.addAll(xx1);
                    xx.retainAll(xx2);
                    yy = new ArrayList();
                    yy.addAll(yy1);
                    yy.retainAll(yy2);
                    double xy1 = xx.size();
                    double xy2 = yy.size();
                    double ovlp = xy1 * xy2 / (x1 * y1 + x2 * y2 - xy1 * xy2);
                    if (!(ovlp > maxov)) continue;
                    maxov = ovlp;
                    mi = kset[i];
                    mj = kset[j];
                }
            }
            if (maxov > ovlpcf) {
                xx1 = this.bclus.get(mj).getFtuple();
                yy1 = this.bclus.get(mj).getStuple();
                xx2 = this.bclus.get(mi).getFtuple();
                yy2 = this.bclus.get(mi).getStuple();
                HashSet<String> nxx = new HashSet<String>(xx1);
                nxx.addAll(xx2);
                nyy = new HashSet<String>(yy1);
                nyy.addAll(yy2);
                xx1 = new ArrayList<String>(nxx);
                yy1 = new ArrayList<Object>(nyy);
                clsBinode bn = new clsBinode(xx1, yy1);
                this.bclus.put(mj, bn);
                this.bclus.remove(mi);
                continue;
            }
            ovchk = false;
        }
    }

    public void filtercluster(int from, int to) {
        ArrayList<Integer> ritem = new ArrayList<Integer>();
        for (Integer key : this.bclus.keySet()) {
            int csize = this.bclus.get(key).getFtuple().size() * this.bclus.get(key).getStuple().size();
            if (csize >= from && csize <= to) continue;
            ritem.add(key);
        }
        this.bclus.keySet().removeAll(ritem);
    }

    public void filterclustersel(ArrayList sl) {
        this.bclus.keySet().removeAll(sl);
    }
}

